/**
 * Enter the Sphere

 Leads in from the beginning of the game.

 This is the initial cutscene, where everything starts. Daniel is in
 his room one moment, and inside his computer the next.

 A bedroom, belonging to DANIEL. It's a bit messy, with papers strewn
 over his desk, a few on the floor, and items of clothing on his bed.
 The computer stands out in the disarray.

 * Daniel comes across Sphere.
 * Daniel installs Sphere and tries it out.
 * Then the computer does some wacky stuff and Daniel is dragged into it.

 */

// We may trigger this script many times, but only run this scene once
if(!GetMapFlag('enterthesphere')) {

	// At this moment, the player should not be able to move.
	QCutScene_Start();

	// Clear the event markers, we want to start with a clean slate.
	ClearEventMarker();

	// Daniel enters his room and goes to his computer
	nQ( { action: 'Move', sprite: 'Daniel', direction: 'north', tiles: 7 } );
	nQ( { action: 'Move', sprite: 'Daniel', direction: 'east', tiles: 7 } );
	nQ( { action: 'Move', sprite: 'Daniel', direction: 'northeast', tiles: 3 } );
	nQ( { action: 'Move', sprite: 'Daniel', direction: 'north', tiles: 3 } );

	// Moves east, but facing the previous direction (north), and then looknorth when finished moving
	nQ( { action: 'Move', sprite: 'Daniel', direction: 'east', tiles:  1, faceDirection: false, standstill: 'looknorth'} );
	// Move Daniel a little bit down, causing a 'sitting down' effect.
	nQ( { action: 'DeltaXY', sprite: 'Daniel', dy: 6 } );

	// He boots up the computer
	nQ({ action: 'Animate',
		sprite: 'Feek_Computer',
		direction: 'startup',
	});

	// Wait for 60 frames (about a second)
	zQ(60);

	// And surfs the web
	nQ({ action: 'Talk',
		portrait: "portrait/daniel.png",
		caption: "Daniel",
		text: "Hmm... what's this? Sphere?\nLooks like fun. Let's download this!"
	});

	// The computer behaves erratically
	nQ({ action: 'Animate',
		sprite: 'Feek_Computer',
		direction: 'overload',
		stayonlastframe: true
	});

	// The computer is overloaded
	nQ({ action: 'Animate',
		sprite: 'Feek_Computer',
		direction: 'overloaded',
		loop: true
		/* wait: false // When loop=true, wait is false by default */
	});

	nQ({ action: 'Hiccup',
		sprite: 'Daniel'
	});

	// Show a balloon above Daniel (only 1 balloon can be displayed at a time)
	Qballoon('HELP!', 10, 'Daniel', -1);

	nQ({ scenelet: 'SpiralTowards', 
		sprite: 'Daniel',
		other: 'Feek_Computer',
		anglespeed: 0.1, // Rotate around the PC
		radialspeed: -0.4, // Get sucked into the PC
		shrinkspeed: -0.005, // Get smaller
		rotatespeed: 0.08, // spin Daniel around
		restore: false 
	});

	// Disable balloon (Just in case the balloon is still displaying)
	Qballoon(false);

	// Move to another map
	nQ({ action: 'Warp',
		rmp: 'glitch/empty.rmp',
		fade: 'toblack',
		wait: true // Wait until we warped to that map
	});

	// TODO: Replace with falling and thud sound effects
	Qballoon('THUD!', 1, 'Daniel', -1);

	// Wait for 60 frames
	zQ(60);

	// Cleanup the mess scenelet: 'SpiralTowards' made
	nQ(SetPersonScaleFactor, null, 'Daniel', 1, 1);
	nQ(SetPersonAngle, null, 'Daniel', 0);

	// Make Daniel fall flat on his face
	nQ(SetPersonDirection, null, 'Daniel', 'lookeast');
	nQ(SetPersonAngle, null, 'Daniel', Math.PI/2 );

	// Fade in. Takes 120 frames to finish, this is about 2 seconds.
	nQ(SetColorMask, null, CreateColor(0, 0, 0, 0), 120, 'enterthesphere fadein');

	// Wait for the fade in, then
	zQ(120);

	// Make Daniel stand up
	nQ(SetPersonAngle, null, 'Daniel', 0);

	// Careful, Talk doesnt work when SetColorMask is still active
	nQ({ action: 'Talk',
		portrait: "portrait/daniel.png",
		caption: "Daniel",
		text: "Wow, I hit my head pretty hard to be seeing such strange patterns.\n"
		+ "I'll find the kitchen sink and maybe get a drink."
	});

	// Look around
	nQ(SetPersonDirection, null, "Daniel", "looknorth");
	zQ(40);
	nQ(SetPersonDirection, null, "Daniel", "lookwest");
	zQ(40);
	nQ(SetPersonDirection, null, "Daniel", "looksouth");
	zQ(40);
	nQ(SetPersonDirection, null, "Daniel", "lookwest");
	zQ(40);

	nQ({ action: 'Talk',
		portrait: "portrait/daniel.png",
		caption: "Daniel",
		text: "I _really_ need to find that sink."
	});

	nQ( function(){
		Game.lithonite.EMOTIONS.setEmoticon("sfx/arrowticons.rss",'arrow_east', Game.lithonite.GIP);
	});

	//At this moment, the player should be able to move again.
	QCutScene_End();

	// Now, while Daniel can move again, wait until he has moved, or hasnt moved for 4 seconds 
	// or nobody touches the cursor keys for more than 240 frames (at 60 fps, thats 4 secs)
	// Game.lithonite.idle increases by one each frame that the cursors are untouched, and resets to zero when they finally do.
	nQ("Game.lithonite.idle = 1;");
	wQ("Game.lithonite.idle==0||Game.lithonite.idle>240");

	// If the player hasnt moved Daniel by now, display a big cursor, hopefully the player gets it...
	nQ( function(){
		if(Game.lithonite.idle)
			Game.lithonite.EMOTIONS.setEmoticon("sfx/arrowticons.rss",'arrow_east', Game.lithonite.GIP);
	});

	// ...aaaand ACTION! Now play all things we queued.
	CutScene_Play('Enter the Sphere');
	// play() returns immediately, because all events are controlled in the update/render scripts. 

}else{
	// We already visited this room

};


